var log4js = require("log4js");
log4js.configure({
  appenders: { cronNetCDF: { type: "file", filename: "logs/cronNetCDF.log" } },
  categories: { default: { appenders: ["cronNetCDF"], level: "trace" } }
});
const logger = log4js.getLogger("cronNetCDF");

const cron = require('node-cron');
var execSync = require('child_process').execSync, child;
const https = require("https");
const fs = require('fs');

const SHOM_URL = '/telechargement/oceano/';
const HOST_NAME = 'services.data.shom.fr';
const CURRENTS_URL = 'HYDRODYN-SURF_HYCOM3D-SURF_R1000_MANGASC_';
const CURRENTS_DIR = './data/currents/';
const WAVES_URL = 'VAGUES_WW3_R1122_FINIS-200M_';
const WAVES_DIR = './data/waves/';

//THEMATIQUE_NOMMODELE_RXXXX_EMPRISE-GEO-XXXM_AAAAMMJJ.nc.gz
//https://services.data.shom.fr/telechargement/oceano/
//VAGUES_WW3_R1120_MANCHE-SUD-500M_20210904.dl/file/VAGUES_WW3_R1120_MANCHE-SUD-500M_20210904.dl.zip
//VAGUES_WW3_R1122_FINIS-200M_20210904.dl/file/VAGUES_WW3_R1122_FINIS-200M_20210904.dl.zip

var cronNetCDF = {};
(function () {
    cronNetCDF.formatedDate = function () {
        var date = new Date();
        var month = date.getMonth() + 1;
        var day = date.getDate();
        var formatedDate = date.getFullYear() + String("0" + month).slice(-2) + String("0" + day).slice(-2);
        return formatedDate;
    };
    cronNetCDF.clear = function (dir) {
        try {
            const clear = execSync('rm ' + dir + '*').toString();
            logger.info('clear old file');
        } catch (error) {
             logger.warn(error.message);  
        }
    };
    cronNetCDF.loadData = function (date, dataUrl, dataDir) {
        var url = 'https://' + HOST_NAME + SHOM_URL + dataUrl + date + '.dl/file/' + dataUrl + date + '.dl.zip';
        logger.info(url);
        var filename = dataUrl + date;
        var PATH = filename + '.dl.zip';
        var request = https.get(url, function (response) {
            var file;
            if (response.statusCode === 200) {
                file = fs.createWriteStream(PATH);
                response.pipe(file);
            }
            file.on('finish', () => {
                try {
                    const zip = execSync('unzip ./' + filename + '.dl.zip').toString();
                    const gunzip = execSync('gunzip ./' + filename + '.nc.gz').toString();
                    const mv = execSync('mv ./' + filename + '.nc ' + dataDir).toString();
                    const rmAll = execSync('rm ./' + filename + '.*').toString();
                } catch (error) {
                    logger.error(error.message); 
                }
            });
            request.setTimeout(60000, function () {
                request.abort();
            });
        });
    };
})();

cron.schedule('0 1 * * *', function () {
    var date = cronNetCDF.formatedDate();
    cronNetCDF.clear(CURRENTS_DIR);
    cronNetCDF.loadData(date, CURRENTS_URL, CURRENTS_DIR);
    cronNetCDF.clear(WAVES_DIR);
    cronNetCDF.loadData(date, WAVES_URL, WAVES_DIR);
});
